// DeadEasy_GliaAdult macro for ImageJ
// by Manuel Guillermo Forero.
// e-mail: mgforero@yahoo.es

macro "DeadEasy GliaAdult[g]"
{
run("Display...", " ");//Verifies the correct LUT in the image's options
//---------------------------------------------------------------------------------------------------------------------
values=getArgument();
if (lengthOf(values)==0)
{
	Dialog.create("DeadEasy GliaAdult");
	Dialog.addNumber("Outliers filter radius (pixels):",10);
	Dialog.addNumber("Outliers threshold (grey levels):",50);
	Dialog.show();
	radius=Dialog.getNumber();
	threshold=Dialog.getNumber();
}
else
{
	a=split(values,"");
	radius=a[0];
	threshold=a[1];
}
//---------------------------------------------------------------------------------------------------------------------
title=getTitle();
getVoxelSize(w, h, d, unit);
//---------------------------------------------------------------------------------------------------------------------
run("Duplicate...", "title=Open duplicate");
run("Minimum...", "radius=4 stack");
run("Maximum...", "radius=4 stack");
imageCalculator("Subtract stack",title,"Open");
selectWindow("Open");
close();
//---------------------------------------------------------------------------------------------------------------------
//run("Despeckle", "stack");
run("Duplicate...","title=Filtered duplicate");
run("Remove Outliers...", "radius="+radius+" threshold="+threshold+" which=Bright stack");
imageCalculator("Subtract stack",title,"Filtered");
selectWindow("Filtered");
close();
setThreshold(1, 255);
run("Convert to Mask","  black");
run("Majority black 2D", "stack");
//run("MajorityBlack3D ");
//---------------------------------------------------------------------------------------------------------------------
run("Label3D18C ");
//---------------------------------------------------------------------------------------------------------------------
minVol=3;
maxVol=99999999;//A very big value is employed as maximal volume
setVoxelSize(w, h, d, unit);
run("VolumeFilter ","minimum="+minVol+" maximum="+maxVol+" show");
setMinAndMax(0.1,1);
rename(title+" result");
